{{- define "configseeder.labels" }}
helm.sh/chart: {{ printf "%s-%s" .Chart.Name .Chart.Version | trunc 63 | replace "+" "_" }}
app.kubernetes.io/name: {{ .Chart.Name }}
app.kubernetes.io/managed-by: {{ .Release.Service }}
app.kubernetes.io/instance: {{ .Release.Name }}
app.kubernetes.io/version: {{ .Chart.AppVersion }}
app.kubernetes.io/component: management
app.kubernetes.io/part-of: configseeder
{{- end }}

{{- define "configseeder.matchlabels" }}
app.kubernetes.io/name: {{ .Chart.Name }}
app.kubernetes.io/instance: {{ .Release.Name }}
app.kubernetes.io/component: management
app.kubernetes.io/part-of: configseeder
{{- end }}

{{- define "custom.annotations" }}
{{- range $key, $value := .Values.customAnnotations }}
{{ $key | quote }}: {{ $value | quote }}
{{- end }}
{{- end }}

{{- define "custom.ingressAnnotations" }}
{{- range $key, $value := .Values.ingress.annotations }}
{{ $key | quote }}: {{ $value | quote }}
{{- end }}
{{- end }}

{{- define "custom.labels" }}
{{- range $key, $value := .Values.customLabels }}
{{ $key | quote }}: {{ $value | quote }}
{{- end }}
{{- end }}
