# ConfigSeeder Management H2

## General Information

This Helm Chart allows to install the configuration management system ConfigSeeder. 

Additional Information about ConfigSeeder and its features can be retrieved at the following locations:

* https://www.configseeder.com
* https://configseeder.com/documentation/

### Intended use

This specific Helm Chart installs ConfigSeeder with H2 persistency and therefore is not intended for use in production.

ConfigSeeder with H2 persistency is intended for prototyping and executing proof of concepts. If you are looking for a ConfigSeeder ready to be used in 
production, you should use the Helm Charts with persistency based on Postgres or MSSQL. 

## Configuring ConfigSeeder

### Default configuration

This Helm Chart comes with a default configuration which allows you to use the ConfigSeeder right on.

The following configuration is done:

* Setup our Keycloak as default OIDC IDP
* Use default private and public key for jwt encryption
* Use default encryption secret

### Replacing the default `application.yml`

An individual `application.yml` can be provided with the helm's `--set-file` argument:

```
helm --kube-context=${context} -n "$ns" template configseeder-h2 configseeder-management-h2 \
     --values <your-values>.yaml \
     --set-file application_configuration=./<your-application.yml> \
     | kubectl --context=${context} -n "$ns" apply -f -
```

You can find an overview of all configuration options in our documentation.

### Replacing the default jwt encryption key and encryption secret

The default encryption credentials can be overwritten with the following options in your values file:

```
configseeder:
  encryptionSecret: "...encryptionSecret..."
  jwtPrivateKey: "...jwt-private-key..."
  jwtPublicKey: "...jwt-public-key..."
```

The tool for creating the keys can be downloaded from our [website](https://configseeder.com/download), look for _ConfigSeeder Util_.

## Configuring Kubernetes specifics
  
### Enabling PSP

The Helm Chart comes with disabled Pod Security Policies. PSP can be activated with the following options in your values.file:

```
psp:
  create: true
  name: configseeder-value-provider
  existingPspClusterRole: psp:restricted
```

Please be aware that no PodSecurityPolicy will be created by the chart. The name of a ClusterRole has to be provided, the chart will create a 
RoleBinding to this already existing ClusterRole.