# ConfigSeeder Management SqlServer

## General Information

This Helm Chart allows to install the configuration management system ConfigSeeder. 

Additional Information about ConfigSeeder and its features can be retrieved at the following locations:

* https://www.configseeder.com
* https://configseeder.com/documentation/

### Intended use

This specific Helm Chart installs ConfigSeeder with SqlServer persistency and is ready to be used in production. You will need a valid license to use this 
variant of ConfigSeeder. If you don't have a license yet, please [contact us](https://configseeder.com/contact/).

This Helm Chart comes without a complete configuration and therefore must be configured manually.
If you are looking for a ConfigSeeder ready to be used for prototyping or doing a proof of concept, you should use the Helm Charts with persistency based on H2. 

## Configuring ConfigSeeder

### Default configuration

This Helm Chart comes only partially configured. The following configuration is done:

* Setup our Keycloak as default OIDC IDP

In comparison to our Helm Chart with H2 persistency, the following configuration is missing / has to be done by you:

* Provide a private and public key for jwt encryption
* Provide an encryption secret

### Replacing the default `application.yml`

An individual `application.yml` can be provided with the helm's `--set-file` argument:

```
helm --kube-context=${context} -n "$ns" template configseeder-sqlserver configseeder-management-sqlserver \
     --values <your-values>.yaml \
     --set-file application_configuration=./<your-application.yml> \
     | kubectl --context=${context} -n "$ns" apply -f -
```

You can find an overview of all configuration options in our documentation.

### Replacing the default jwt encryption key and encryption secret

An encryption credentials must be set with the following options in your values file:

```
configseeder:
  encryptionSecret: "...encryptionSecret..."
  jwtPrivateKey: "...jwt-private-key..."
  jwtPublicKey: "...jwt-public-key..."
```

The tool for creating the keys can be downloaded from our [website](https://configseeder.com/download), look for _ConfigSeeder Util_.

## Configuring Kubernetes specifics
  
### Enabling PSP

The Helm Chart comes with disabled Pod Security Policies. PSP can be activated with the following options in your values.file:

```
psp:
  create: true
  name: configseeder-value-provider
  existingPspClusterRole: psp:restricted
```

Please be aware that no PodSecurityPolicy will be created by the chart. The name of a ClusterRole has to be provided, the chart will create a 
RoleBinding to this already existing ClusterRole.